import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import wellness1 from '/images/wellness-1.jpg'
import wellness2 from '/images/wellness-2.jpg'
import wellness3 from '/images/wellness-3.jpg'
import wellness4 from '/images/wellness-4.jpg'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentIndex, setCurrentIndex] = useState(0)
  
  // Заглушки для изображений
  const images = [
    {
      id: 1,
      src: wellness1,
      title: 'Wellness подход'
    },
    {
      id: 2,
      src: wellness2,
      title: 'Здоровье и энергия'
    },
    {
      id: 3,
      src: wellness3,
      title: 'Персональный план'
    },
    {
      id: 4,
      src: wellness4,
      title: 'Ваш результат'
    }
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentIndex((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentIndex((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentIndex((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentIndex(index)
  }

  return (
    <div className="slider-container-wellness">
      <div className="slider-wrapper-wellness">
        {images.map((img, index) => (
          <div
            key={img.id}
            className={`slide-wellness ${index === currentIndex ? 'active' : ''}`}
          >
            <img src={img.src} alt={img.title} className="slide-image-wellness" />
            <div className="slide-overlay-wellness"></div>
            <div className="slide-content-wellness">
              <h3 className="slide-title-wellness">{img.title}</h3>
            </div>
          </div>
        ))}
      </div>
      <button className="slider-btn-wellness prev-wellness" onClick={goToPrevious}>
        <ChevronLeft className="slider-icon-wellness" size={24} />
      </button>
      <button className="slider-btn-wellness next-wellness" onClick={goToNext}>
        <ChevronRight className="slider-icon-wellness" size={24} />
      </button>
      <div className="slider-dots-wellness">
        {images.map((_, index) => (
          <button
            key={index}
            className={`dot-wellness ${index === currentIndex ? 'active' : ''}`}
            onClick={() => goToSlide(index)}
            aria-label={`Go to slide ${index + 1}`}
          />
        ))}
      </div>
    </div>
  )
}

export default ImageSlider
